/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.Pair;

public class HermiteInterpolator {
    private Map<Pair<Integer, Float>, Result> resultCache = new HashMap<Pair<Integer, Float>, Result>();
    private Point[] points;

    public HermiteInterpolator(Point ... points) {
        this.points = points;
    }

    public Result get(int index, float progress) {
        return this.resultCache.computeIfAbsent((Pair<Integer, Float>)Pair.of((Object)index, (Object)Float.valueOf(progress)), pair -> {
            Point p1 = this.getPoint(index);
            Point p2 = this.getPoint(index + 1);
            double pX = this.point(((Point)p1).pos.field_72450_a, ((Point)p2).pos.field_72450_a, ((Point)p1).control.field_72450_a, ((Point)p2).control.field_72450_a, progress);
            double pY = this.point(((Point)p1).pos.field_72448_b, ((Point)p2).pos.field_72448_b, ((Point)p1).control.field_72448_b, ((Point)p2).control.field_72448_b, progress);
            double pZ = this.point(((Point)p1).pos.field_72449_c, ((Point)p2).pos.field_72449_c, ((Point)p1).control.field_72449_c, ((Point)p2).control.field_72449_c, progress);
            double aX = this.angle(((Point)p1).pos.field_72450_a, ((Point)p2).pos.field_72450_a, ((Point)p1).control.field_72450_a, ((Point)p2).control.field_72450_a, progress);
            double aY = this.angle(((Point)p1).pos.field_72448_b, ((Point)p2).pos.field_72448_b, ((Point)p1).control.field_72448_b, ((Point)p2).control.field_72448_b, progress);
            double aZ = this.angle(((Point)p1).pos.field_72449_c, ((Point)p2).pos.field_72449_c, ((Point)p1).control.field_72449_c, ((Point)p2).control.field_72449_c, progress);
            return new Result(new Vector3d(pX, pY, pZ), new Vector3d(aX, aY, aZ));
        });
    }

    public Point getPoint(int index) {
        return this.points[MathHelper.func_76125_a((int)index, (int)0, (int)(this.points.length - 1))];
    }

    public int getSize() {
        return this.points.length;
    }

    public double point(double p1, double p2, double t1, double t2, double s) {
        double ss = s * s;
        double sss = s * s * s;
        double a1 = 2.0 * sss - 3.0 * ss + 1.0;
        double a2 = -2.0 * sss + 3.0 * ss;
        double a3 = sss - 2.0 * ss + s;
        double a4 = sss - ss;
        return a1 * p1 + a2 * p2 + a3 * t1 + a4 * t2;
    }

    public double angle(double p1, double p2, double t1, double t2, double s) {
        double ss = s * s;
        double a1 = 6.0 * ss - 6.0 * s;
        double a2 = -6.0 * ss + 6.0 * s;
        double a3 = 3.0 * ss - 4.0 * s + 1.0;
        double a4 = 3.0 * ss - 2.0 * s;
        return a1 * p1 + a2 * p2 + a3 * t1 + a4 * t2;
    }

    public static class Result {
        Vector3d point;
        Vector3d direction;

        public Result(Vector3d point, Vector3d direction) {
            this.point = point;
            this.direction = direction;
        }

        public Vector3d getPoint() {
            return this.point;
        }

        public Vector3d getDir() {
            return this.direction;
        }
    }

    public static class Point {
        private final Vector3d pos;
        private final Vector3d control;

        public Point(Vector3d pos) {
            this.pos = pos;
            this.control = pos;
        }

        public Point(Vector3d pos, Vector3d control) {
            this.pos = pos;
            this.control = control;
        }
    }
}

